% General description of each deployment.
%   Copyright  2020 University of Extremadura (UEx)

% Preamble and common parameters
% -----------------------------------------

clc
clear;
close all;

addpath('data','load','utils','ips');

dataFolder = 'data';
fDefs = getDeploymentDefs();

nonValueToNan = true;
transfTime = false;

% Deployment variables
nBeacons = zeros(1,3);
nSamples = zeros(1,3);
nRP = zeros(1,3);
nPhones = zeros(1,3);
totalArea = zeros(1,3);
obstArea = zeros(1,3);
samplesArea = zeros(1,3);
beaconsArea = zeros(1,3);
prDensity = zeros(1,3);
beaconsDensity = zeros(1,3);

for i=1:1:3
    
    set = fDefs.set(i);
    data = loadSet(set);
    
     % Environment plots
     plotThemAll(set,data);
    
     plotSingleFloor(set,data,0);
     plotSingleFloor(set,data,1);
     plotSingleFloor(set,data,2);
     plotRegions(set,data,2)
    
    totalArea(i) =  getAmpleArea(set); 
    obstArea(i) = getNotAccesibleArea(set);
    
    nBeacons(i) = fDefs.set(i).nBeacons;
    nSamples(i) = size(data.rss,1);
    nPhones(i) = fDefs.set(i).nBeacons;
    samplesArea(i) = getArea(data.coords);
    beaconsArea(i) = getArea(data.bcCoords);
    distSamples(i) = getMaxMinDistance(data.coords);
    distBeacons(i) = getMaxMinDistance(data.bcCoords);

end


% ----------------- Table ------------------------ %

varNames = cell(1,3);
varNames{fDefs.set(1).id} = fDefs.set(1).name;
varNames{fDefs.set(2).id} = fDefs.set(2).name;
varNames{fDefs.set(3).id} = fDefs.set(3).name;
rowNames = {'nBeacons','nSamples','nPhones'...
    'totalArea','obstArea','samplesArea','beaconsArea','distSamples','distBeacons'};
allData = [nBeacons;nSamples;nPhones;totalArea;obstArea;samplesArea;beaconsArea;distSamples;distBeacons];
T = table(allData(:,fDefs.set(1).id),allData(:,fDefs.set(2).id),allData(:,fDefs.set(3).id),...
    'VariableNames',varNames, 'RowNames',rowNames);

disp(T);

% Maximum distance to the closest neighbour

function [dist] = getMaxMinDistance(coords)
    D = squareform(pdist(unique(coords,'rows')));
    D(D==0) = inf;
    dist = max(min(D));
end

function [a] = getArea(coords)
    inds = convhull(coords(:,1),coords(:,2));
    a = polyarea(coords(inds,1),coords(inds,2));
end

